document.addEventListener('DOMContentLoaded', () => {
    const tecnoPageText = document.getElementById('tecnoPageText');
    const servidorSeguroText = document.getElementById('servidorSeguroText');
    
    if (tecnoPageText && servidorSeguroText) {
        gsap.fromTo(tecnoPageText, 
            { strokeDasharray: "400", strokeDashoffset: "400", opacity: 0 }, 
            { duration: 2, strokeDashoffset: "0", opacity: 1, ease: "power2.inOut" }
        );

        gsap.fromTo(servidorSeguroText, 
            { strokeDasharray: "400", strokeDashoffset: "400", opacity: 0 }, 
            { duration: 2, strokeDashoffset: "0", opacity: 1, ease: "power2.inOut", delay: 1 }
        );

        setTimeout(function () {
            document.querySelector('.circle').style.display = 'none';
            document.querySelectorAll('.content-section').forEach(section => section.classList.add('visible'));
            document.querySelector('#formContainer');
            document.querySelector('#uploadStatus');
        }, 2800);
    } else {
        console.error("Los elementos con los IDs proporcionados no se encontraron.");
    }
});
