<?php
session_start();
date_default_timezone_set('America/Asuncion');

$token = $_GET['token'] ?? '';

$conn = new mysqli("correo.com.py", "correopycom_userenviatodo", "mwt6zruWUObF", "correopycom_bd");

if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Leer la información del archivo por token
$stmt = $conn->prepare("SELECT archivo, path_archivo, seña_descarga FROM files WHERE carga_token = ?");
$stmt->bind_param("s", $token);
$stmt->execute();
$stmt->bind_result($filename, $filepath, $downloadCode);
$stmt->fetch();
$stmt->close();

if (!$filename || !file_exists($filepath)) {
    die("Archivo no encontrado.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $enteredCode = $_POST['download_code'] ?? '';

    if ($enteredCode === $downloadCode) {
        if (!isset($_SESSION['downloaded_' . $token])) {
            $computerName = $_POST['computerName'] ?? 'Desconocido';
            $os = $_POST['os'] ?? 'Desconocido';
            $date = date('Y-m-d');
            $time = date('H:i:s');
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['HTTP_CLIENT_IP'] ?? $_SERVER['REMOTE_ADDR'];

            // Guarda la info a la tabla download
            $stmt = $conn->prepare("INSERT INTO download (codigo_archivo, fecha_descarga, hora_descarga, IP, nombre_pc, OS, token_carga) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("sssssss", $filename, $date, $time, $ip, $computerName, $os, $token);

            if (!$stmt->execute()) {
                die("Error al registrar la descarga: " . $stmt->error);
            }

            $stmt->close();
            $_SESSION['downloaded_' . $token] = true;

            
            exit;
        } else {
            die("La descarga ya ha sido registrada.");
        }
    } else {
        echo "<p style='color:red;'>Código de descarga incorrecto.</p>";
    }
}

// Consulta para obtener información de descargas
//d.columna -> tabla download // f.columna -> tabla files 
$stmt = $conn->prepare("SELECT fecha_descarga, hora_descarga, IP, nombre_pc, OS FROM download WHERE token_carga = ? ORDER BY fecha_descarga DESC, hora_descarga DESC");
$stmt->bind_param("s", $token); 
$stmt->execute();
$stmt->bind_result($downloadDate, $downloadTime, $downloadIp, $downloadComputerName, $downloadOs);

$downloads = [];
while ($stmt->fetch()) {
    $downloads[] = [
        'fecha_descarga' => date('d-m-Y', strtotime($downloadDate)),
        'hora_descarga' => $downloadTime,
        'IP' => $downloadIp,
        'nombre_pc' => $downloadComputerName,
        'OS' => $downloadOs
    ];
}
$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Descarga de archivo</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/platform/1.3.6/platform.min.js"></script>
    <script>
        let validDownloadCode = <?php echo json_encode($downloadCode); ?>;

        function getOS() {
            const os = platform.os.family;
            const version = platform.os.version;
            let osVersion = version ? `${os} ${version}` : os;

            return osVersion || 'Unknown OS';
        }

        function enableDownloadButton() {
            const downloadCode = document.getElementById('download_code').value;
            const downloadButton = document.getElementById('download_button');
            downloadButton.disabled = downloadCode !== validDownloadCode;
        }

        function sendClientInfoAndRedirect(event) {
            event.preventDefault();

            const os = getOS();
            const computerName = platform.name || 'Desconocido';
            const downloadCode = document.getElementById('download_code').value;

            if (downloadCode === validDownloadCode) {
                fetch(window.location.href, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded'
                    },
                    body: new URLSearchParams({
                        'os': os,
                        'computerName': computerName,
                        'download_code': downloadCode
                    })
                }).then(response => {
                    if (response.ok) {
                        // Redirigir a la URL de descarga después de registrar la información
                        window.location.href = "download_file.php?token=" + encodeURIComponent(new URLSearchParams(window.location.search).get('token'));
                    } else {
                        console.error('Error al registrar la información del cliente.');
                    }
                }).catch(error => {
                    console.error('Error:', error);
                });
            } else {
                alert("El código de descarga es incorrecto.");
            }
        }
    </script>
</head>
<body>
    <h1>Descargue su archivo</h1>
    <form onsubmit="sendClientInfoAndRedirect(event)">
        <label for="download_code">Ingrese la seña de descarga:</label>
        <input type="text" id="download_code" name="download_code" oninput="enableDownloadButton()" required>
        <button type="submit" id="download_button" disabled>Descargar archivo</button>
    </form>

    <h2>¿Quién ha descargado este archivo?</h2>
    <table border="1">
        <tr>
            <th>Fecha</th>
            <th>Hora</th>
            <th>IP</th>
            <th>Nombre del Equipo</th>
            <th>Sistema Operativo</th>
        </tr>
        <?php foreach ($downloads as $download): ?>
            <tr>
                <td><?= htmlspecialchars($download['fecha_descarga']) ?></td>
                <td><?= htmlspecialchars($download['hora_descarga']) ?></td>
                <td><?= htmlspecialchars($download['IP']) ?></td>
                <td><?= htmlspecialchars($download['nombre_pc']) ?></td>
                <td><?= htmlspecialchars($download['OS']) ?></td>
            </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
