function updateAnimation(progress) {
    // Actualiza la animación basada en el progreso (0 a 1)
    document.querySelector('.truck-button').style.setProperty('--progress', progress);
}

// Inicializar eventos de clic en el botón de animación si es necesario
document.querySelectorAll('.truck-button').forEach(button => {
    button.addEventListener('click', e => {
        e.preventDefault();

        let box = button.querySelector('.box'),
            truck = button.querySelector('.truck');

        if (!button.classList.contains('done')) {

            if (!button.classList.contains('animation')) {

                button.classList.add('animation');

                const files = document.getElementById('fileInput').files;
                const folders = document.getElementById('folderInput').files;
                const totalSize = Array.from(files).reduce((acc, file) => acc + file.size, 0) + Array.from(folders).reduce((acc, file) => acc + file.size, 0);
                let uploadedSize = 0;

                const uploadSpeed = 512 * 1024; // 512 KB/s
                const interval = 100; // cada 100 ms

                const uploadInterval = setInterval(() => {
                    uploadedSize += uploadSpeed * (interval / 1000);
                    const progress = Math.min(uploadedSize / totalSize, 1);
                    button.style.setProperty('--progress', progress);

                    if (uploadedSize >= totalSize) {
                        clearInterval(uploadInterval);
                        button.classList.add('done');
                        gsap.to(truck, {
                            x: 96,
                            duration: 0.4
                        });
                    }
                }, interval);

                gsap.to(button, {
                    '--box-s': 1,
                    '--box-o': 1,
                    duration: .3,
                    delay: .5
                });

                gsap.to(box, {
                    x: 0,
                    duration: .4,
                    delay: .7
                });

                gsap.to(button, {
                    '--hx': -5,
                    '--bx': 50,
                    duration: .18,
                    delay: .92
                });

                gsap.to(box, {
                    y: 0,
                    duration: .1,
                    delay: 1.15
                });

                gsap.set(button, {
                    '--truck-y': 0,
                    '--truck-y-n': -26
                });

                gsap.to(button, {
                    '--truck-y': 1,
                    '--truck-y-n': -25,
                    duration: .2,
                    delay: 1.25
                });
            }
        } else {
            button.classList.remove('animation', 'done');
            gsap.set(truck, {
                x: 4
            });
            gsap.set(button, {
                '--progress': 0,
                '--hx': 0,
                '--bx': 0,
                '--box-s': .5,
                '--box-o': 0,
                '--truck-y': 0,
                '--truck-y-n': -26
            });
            gsap.set(box, {
                x: -24,
                y: -6
            });
        }
    });
});