<?php
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);

if (!empty($input['senderEmail']) && !empty($input['recipientEmail']) && !empty($input['filename'])) {
    // Extrae nombre del archivo TAR
    $filename = $input['filename'];

    // Ruta del archivo TAR directamente del servidor de archivos
    date_default_timezone_set('America/Asuncion');
    $date = date('d-m-Y');
    $subDir = $date . '-' . substr($filename, 0, 18);
    $tarFile = 'uploads_prueba/' . $subDir . '/' . $filename;

    error_log("Ruta completa del archivo TAR: " . $tarFile);

    if (file_exists($tarFile)) {
        $downloadCode = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
        $uploadToken = uniqid();
        $downloaded = 0;

        // Guardar la data subida en la base de datos
        if (saveToDatabase($filename, $tarFile, $uploadToken, $input['senderEmail'], $input['recipientEmail'], $downloadCode, $downloaded)) {
            // Enviar correo después de guardar info en la base de datos
            sendEmail($input['senderEmail'], $input['recipientEmail'], $uploadToken, $downloadCode);
            echo json_encode(['status' => 'success', 'message' => 'Información guardada en la base de datos y correo enviado.']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Error al guardar en la base de datos.']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Archivo TAR no encontrado.']);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Nombre de archivo no proporcionado.']);
}

// Funcion guardado de datos a la tabla files
function saveToDatabase($filename, $filepath, $uploadToken, $senderEmail, $recipientEmail, $downloadCode, $downloaded) {
    $conn = new mysqli("correo.com.py", "correopycom_userenviatodo", "mwt6zruWUObF", "correopycom_bd");

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }
    $expirationDate = date('Y-m-d', strtotime('+60 days'));
    $stmt = $conn->prepare("INSERT INTO files (archivo, path_archivo, carga_token, correo_remitente, correo_destino, seña_descarga, fecha_expiracion, descargado) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssssi", $filename, $filepath, $uploadToken, $senderEmail, $recipientEmail, $downloadCode, $expirationDate, $downloaded);

    if ($stmt->execute()) {
        return true;
    } else {
        return false;
    }

    $stmt->close();
    $conn->close();
}

// Funcion envio de correos
function sendEmail($sender, $recipients, $uploadToken, $downloadCode) {
    $conn = new mysqli("correo.com.py", "correopycom_userenviatodo", "mwt6zruWUObF", "correopycom_bd");

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Obtener fecha de expiracion
    $stmt = $conn->prepare("SELECT fecha_expiracion FROM files WHERE carga_token = ?");
    $stmt->bind_param("s", $uploadToken);
    $stmt->execute();
    $stmt->bind_result($expirationDate);
    $stmt->fetch();
    $stmt->close();
    $conn->close();

    $expirationDateFormatted = date('d-m-Y', strtotime($expirationDate));
    $recipientsArray = explode(',', $recipients);
    $recipientsArray = array_map('trim', $recipientsArray);

    $subjectSender = 'Enlace de descarga de archivos';
    $subjectRecipient = 'Has recibido un archivo';
    $link = 'http://correo.com.py/enviatodo/download.php?token=' . urlencode($uploadToken);
    $messageSender = '
    <html>
    <head>
        <title>' . htmlspecialchars($subjectSender) . '</title>
    </head>
    <body>
        <p>Hola ' . htmlspecialchars($sender) . '!</p>
        <p>Has enviado un archivo a ' . htmlspecialchars($recipients) . '.</p>
        <p>Haga click para descargar: <a href="' . htmlspecialchars($link) . '">Descargar archivos</a></p>
        <p>El código para descargar es: ' . htmlspecialchars($downloadCode) . '</p>
        <p>Este archivo quedará disponible para su descarga hasta: ' . htmlspecialchars($expirationDateFormatted) . ' en nuestros servidores, posterior a eso será eliminado.</p>
        <p>Ante cualquier duda: sac@tecnopage.com</p>
    </body>
    </html>';
    $serverEmail = 'noreply@' . $_SERVER['SERVER_NAME'];

    $headers = 'From: ' . $serverEmail . "\r\n" .
               'Reply-To: ' . $serverEmail . "\r\n" .
               'Content-Type: text/html; charset=UTF-8' . "\r\n" .
               'X-Mailer: PHP/' . phpversion();
    // Enviar correo al remitente
    if (!mail($sender, $subjectSender, $messageSender, $headers)) {
        error_log('Error al enviar copia al remitente ' . $sender, 3, 'email_log.txt');
    }

    // Enviar correo a los destinatarios
    foreach ($recipientsArray as $recipient) {
        $messageRecipient = '
            <html>
            <head>
                <title>' . htmlspecialchars($subjectRecipient) . '</title>
            </head>
            <body>
                <p>Hola ' . htmlspecialchars($recipient) . '!</p>
                <p>Has recibido un archivo de ' . htmlspecialchars($sender) . '.</p>
                <p>Haga click para descargar: <a href="' . htmlspecialchars($link) . '">Descargar archivos</a></p>
                <p>El código para descargar es: ' . htmlspecialchars($downloadCode) . '</p>
                <p>Este archivo quedará disponible para su descarga hasta: ' . htmlspecialchars($expirationDateFormatted) . ' en nuestros servidores, posterior a eso será eliminado.</p>
                <p>Ante cualquier duda: sac@tecnopage.com</p>
            </body>
            </html>';
        if (!mail(trim($recipient), $subjectRecipient, $messageRecipient, $headers)) {
            error_log('Error al enviar correo a ' . $recipient, 3, 'email_log.txt');
        }
    }
}

?>
