const modal = document.getElementById("termsModal");
const checkbox = document.getElementById("termsCheckbox");
const span = document.getElementsByClassName("close")[0];
const acceptButton = document.getElementById("acceptTerms");
const rejectButton = document.getElementById("rejectTerms");
const sendEmailButton = document.getElementById("sendEmailButton");
const progressBarContainer = document.getElementById('uploadProgressBarContainer');
const progressBar = document.getElementById('uploadProgressBar');
const progressText = document.getElementById('uploadProgressText');
const sendAnotherDiv = document.getElementById('sendAnother');
const sendAnotherLink = document.getElementById('sendAnotherLink');
const form = document.getElementById('uploadForm');

function validateForm() {
    const email = document.getElementById('senderEmail').value.trim();
    const recipientEmail = document.getElementById('recipientEmail').value.trim();
    const folderFiles = document.getElementById('folderInput').files.length;
    const regularFiles = document.getElementById('fileInput').files.length;
    const senderEmailError = document.getElementById('senderEmailError');
    const recipientEmailError = document.getElementById('recipientEmailError');

    const emailRegex = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.(?!co\b)[a-zA-Z]{2,}$/;
    const recipientEmails = recipientEmail.split(',').map(email => email.trim());

    let valid = true;

    // Validación campo tu correo
    if (email === '') {
        senderEmailError.textContent = 'El correo electrónico es obligatorio.';
        valid = false;
    } else if (!emailRegex.test(email)) {
        senderEmailError.textContent = 'Correo electrónico inválido.';
        valid = false;
    } else {
        senderEmailError.textContent = '';
    }

    // Validación campo correos destinatarios
    if (recipientEmail === '') {
        recipientEmailError.textContent = 'El correo electrónico de destinatarios es obligatorio.';
        valid = false;
    } else if (!recipientEmails.every(email => emailRegex.test(email))) {
        recipientEmailError.textContent = 'Algunos correos de destinatarios son inválidos.';
        valid = false;
    } else {
        recipientEmailError.textContent = '';
    }

    // Validación carga archivo o carpeta
    if (folderFiles === 0 && regularFiles === 0) {
        valid = false;
    }

    // Validación checkbox
    if (!checkbox.checked) {
        valid = false;
    }

    // Habilita y deshabilita botón enviar correo
    sendEmailButton.disabled = !valid;
}

// Validar entradas del formulario
document.getElementById('senderEmail').addEventListener('blur', validateForm);
document.getElementById('recipientEmail').addEventListener('blur', validateForm);
document.getElementById('folderInput').addEventListener('change', validateForm);
document.getElementById('fileInput').addEventListener('change', validateForm);
checkbox.addEventListener('change', validateForm);

checkbox.addEventListener('change', function () {
    if (checkbox.checked) {
        modal.classList.add("show");
    }
});

span.onclick = function () {
    closeModal();
    validateForm();
}

window.onclick = function (event) {
    if (event.target === modal) {
        closeModal();
        validateForm();
    }
}

acceptButton.onclick = function () {
    closeModal();
    checkbox.checked = true;
    validateForm();
}

rejectButton.onclick = function () {
    closeModal();
    checkbox.checked = false;
    validateForm();
}

function closeModal() {
    modal.classList.remove("show");
    checkbox.checked = false;
}

progressBarContainer.style.display = 'none';

function uploadFiles(callback) {
    const folderInput = document.getElementById('folderInput');
    const fileInput = document.getElementById('fileInput');
    const formData = new FormData();
    let tarFilename = '';

    if (folderInput.files.length > 0) {
        Array.from(folderInput.files).forEach(file => {
            formData.append('folderFiles[]', file, file.webkitRelativePath);
        });
    }

    if (fileInput.files.length > 0) {
        Array.from(fileInput.files).forEach(file => {
            formData.append('individualFiles[]', file);
        });
    }

    const xhr = new XMLHttpRequest();
    xhr.open('POST', 'upload.php', true);
    progressBarContainer.style.display = 'block';

    // Actualiza la barra de progreso
    xhr.upload.onprogress = function (event) {
        if (event.lengthComputable) {
            const percentComplete = Math.round((event.loaded / event.total) * 100);
            progressBar.style.width = percentComplete + '%';
            progressText.textContent = percentComplete + '%';
        }
    };

    xhr.onload = function () {
        if (xhr.status === 200) {
            try {
                const response = JSON.parse(xhr.responseText);
                if (response.success) {
                    tarFilename = response.tarFilename;
                    if (callback) callback(tarFilename);
                } else {
                    console.error('Error en la subida de archivos:', response.error);
                }
            } catch (e) {
                console.error('Error al analizar la respuesta JSON:', e);
            }
        } else {
            console.error('Error en la subida de archivos:', xhr.statusText);
        }
    };

    xhr.send(formData);
}

sendEmailButton.addEventListener('click', function () {
    document.getElementById('progressWarning').style.display = 'block';
    const senderEmail = document.getElementById('senderEmail').value.trim();
    const recipientEmail = document.getElementById('recipientEmail').value.trim();

    uploadFiles(function(tarFilename) {
        const xhr = new XMLHttpRequest();
        xhr.open('POST', 'save_to_db.php', true);
        xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
        xhr.onload = function () {
            if (xhr.status === 200) {
                // console.log('Respuesta del servidor:', xhr.responseText);
                document.getElementById('sendEmailButton').value = 'Correo enviado';
                sendAnotherDiv.style.display = 'block';
            } else {
                console.error('Error guardando en la base de datos:', xhr.statusText);
            }
        };
        xhr.send(JSON.stringify({ 
            senderEmail: senderEmail,
            recipientEmail: recipientEmail,
            filename: tarFilename
        }));
    });
});

sendAnotherLink.addEventListener('click', function (event) {
    event.preventDefault();
    form.reset();
    sendAnotherDiv.style.display = 'none';
    document.getElementById('sendEmailButton').value = 'Enviar correo';
    progressBarContainer.style.display = 'none';
    progressBar.style.width = '0%';
    progressText.textContent = '0%';
    sendEmailButton.disabled = true;
});
