<?php
ob_start();

$uploadDir = 'uploads_prueba/';
$response = ['success' => false, 'tarFilename' => '', 'error' => ''];

// Manejo de carga de carpeta y sus archivos combinado a archivos individuales(misma subida)
if (!empty($_FILES['folderFiles']['name']) || !empty($_FILES['individualFiles']['name'])) {
    date_default_timezone_set('America/Asuncion');
    $date = date('d-m-Y');
    $rootDir = '';

    if (!empty($_FILES['folderFiles']['name'])) {
        $rootDir = explode('/', $_FILES['folderFiles']['full_path'][0])[0];
    } else if (!empty($_FILES['individualFiles']['name'])) {
        $rootDir = $_FILES['individualFiles']['name'][0];
    }

    $rootDirMd5 = md5($rootDir);
    $subDir = $date . '-' . substr($rootDirMd5, 0, 18);
    $subDirPath = $uploadDir . $subDir;

    if (!file_exists($subDirPath)) {
        if (mkdir($subDirPath, 0777, true)) {
            error_log("Directorio creado: $subDirPath");
        } else {
            $response['error'] = 'Fallo al crear el directorio';
            ob_end_clean();
            header('Content-Type: application/json');
            echo json_encode($response);
            exit;
        }
    }

    // Manejo de carga de carpeta y sus archivos(separado)
    if (!empty($_FILES['folderFiles']['name'])) {
        foreach ($_FILES['folderFiles']['full_path'] as $key => $relativePath) {
            $fileTmpPath = $_FILES['folderFiles']['tmp_name'][$key];
            $destinationPath = $subDirPath . '/' . $relativePath;
            $destinationDir = dirname($destinationPath);

            if (!file_exists($destinationDir)) {
                if (mkdir($destinationDir, 0777, true)) {
                    error_log("Directorio creado: $destinationDir");
                } else {
                    $response['error'] = 'Fallo al crear el directorio de destino';
                    ob_end_clean();
                    header('Content-Type: application/json');
                    echo json_encode($response);
                    exit;
                }
            }

            if (move_uploaded_file($fileTmpPath, $destinationPath)) {
                error_log("Archivo $relativePath de la carpeta cargado exitosamente");
            } else {
                $response['error'] = 'Error cargando archivos de carpeta';
                ob_end_clean();
                header('Content-Type: application/json');
                echo json_encode($response);
                exit;
            }
        }
    }

    // Manejo de carga de archivos individuales(separado)
    if (!empty($_FILES['individualFiles']['name'])) {
        foreach ($_FILES['individualFiles']['name'] as $key => $name) {
            $filePath = $subDirPath . '/' . basename($name);
            if (move_uploaded_file($_FILES['individualFiles']['tmp_name'][$key], $filePath)) {
                error_log("Archivo $name individual cargado exitosamente");
            } else {
                $response['error'] = 'Error cargando archivos individuales';
                ob_end_clean();
                header('Content-Type: application/json');
                echo json_encode($response);
                exit;
            }
        }
    }

    // Creacion archivo .tar
    $tarFile = $subDirPath . '/' . $rootDirMd5 . '.tar';
    if (file_exists($tarFile)) {
        unlink($tarFile);
    }
    createTar($subDirPath, $tarFile);

    // Elimina carpeta original subida
    deleteDir($subDirPath, $tarFile);

    $response['success'] = true;
    $response['tarFilename'] = basename($tarFile);
} else {
    $response['error'] = 'Archivo no subido';
}

ob_end_clean();
header('Content-Type: application/json');
echo json_encode($response);

function createTar($source, $destination) {
    $tar = new PharData($destination);
    $tar->buildFromDirectory($source);
    unset($tar);
}

function deleteDir($dirPath, $tarFilePath) {
    if (!is_dir($dirPath)) {
        return;
    }

    $tarFileName = basename($tarFilePath);

    $files = new RecursiveIteratorIterator(
        new RecursiveDirectoryIterator($dirPath, RecursiveDirectoryIterator::SKIP_DOTS),
        RecursiveIteratorIterator::CHILD_FIRST
    );

    foreach ($files as $fileinfo) {
        if (!$fileinfo->isDir() && $fileinfo->getFilename() !== $tarFileName) {
            unlink($fileinfo->getRealPath());
        }
    }
}
?>
